/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class MotifInternalFrameTitlePane
extends JComponent
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    SystemButton systemButton;
    MinimizeButton minimizeButton;
    MaximizeButton maximizeButton;
    JPopupMenu systemMenu;
    Title title;
    JInternalFrame iFrame;
    Color color;
    Color highlight;
    Color shadow;
    static final Font defaultTitleFont = new Font("SansSerif", 0, 12);
    public static final int BUTTON_SIZE = 19;
    private static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    private static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    private static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    private static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    private static final String MOVE_CMD = UIManager.getString("InternalFrameTitlePane.moveButtonText");
    private static final String SIZE_CMD = UIManager.getString("InternalFrameTitlePane.sizeButtonText");
    final int RESTORE_MENU_ITEM = 0;
    final int MOVE_MENU_ITEM = 1;
    final int SIZE_MENU_ITEM = 2;
    final int MINIMIZE_MENU_ITEM = 3;
    final int MAXIMIZE_MENU_ITEM = 4;
    final int SEPARATOR_MENU_ITEM = 5;
    final int CLOSE_MENU_ITEM = 6;
    static Dimension buttonDimension = new Dimension(19, 19);

    protected void hideSystemMenu() {
        this.systemMenu.setVisible(false);
    }

    protected void showSystemMenu() {
        this.systemMenu.show(this.systemButton, 0, 19);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        int n2 = this.getWidth();
        this.systemButton.setBounds(0, 0, 19, 19);
        int n3 = n2 - 19;
        if (this.iFrame.isMaximizable()) {
            this.maximizeButton.setBounds(n3, 0, 19, 19);
            n3 -= 19;
        } else if (this.maximizeButton.getParent() != null) {
            this.maximizeButton.getParent().remove(this.maximizeButton);
        }
        if (this.iFrame.isIconifiable()) {
            this.minimizeButton.setBounds(n3, 0, 19, 19);
            n3 -= 19;
        } else if (this.minimizeButton.getParent() != null) {
            this.minimizeButton.getParent().remove(this.minimizeButton);
        }
        this.title.setBounds(19, 0, n3, 19);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (CLOSE_CMD.equals(actionEvent.getActionCommand()) && this.iFrame.isClosable()) {
                this.iFrame.doDefaultCloseAction();
            } else if (ICONIFY_CMD.equals(actionEvent.getActionCommand()) && this.iFrame.isIconifiable()) {
                if (!this.iFrame.isIcon()) {
                    this.iFrame.setIcon(true);
                } else {
                    this.iFrame.setIcon(false);
                }
            } else if (MAXIMIZE_CMD.equals(actionEvent.getActionCommand()) && this.iFrame.isMaximizable()) {
                if (!this.iFrame.isMaximum()) {
                    this.iFrame.setMaximum(true);
                } else {
                    this.iFrame.setMaximum(false);
                }
            } else if (RESTORE_CMD.equals(actionEvent.getActionCommand()) && this.iFrame.isMaximizable() && this.iFrame.isMaximum()) {
                this.iFrame.setMaximum(false);
            } else if (RESTORE_CMD.equals(actionEvent.getActionCommand()) && this.iFrame.isIconifiable() && this.iFrame.isIcon()) {
                this.iFrame.setIcon(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (this.systemMenu.isVisible()) {
            this.systemMenu.setVisible(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
        boolean bl2 = false;
        if ("selected".equals(string)) {
            this.repaint();
        } else if ("maximum".equals(string)) {
            bl2 = (Boolean)propertyChangeEvent.getNewValue();
            this.systemMenu.getComponentAtIndex(0).setEnabled(bl2);
            this.systemMenu.getComponentAtIndex(4).setEnabled(!bl2);
        } else if ("icon".equals(string)) {
            bl2 = (Boolean)propertyChangeEvent.getNewValue();
            this.systemMenu.getComponentAtIndex(0).setEnabled(bl2);
            if (jInternalFrame.isMaximizable()) {
                this.systemMenu.getComponentAtIndex(4).setEnabled(true);
            } else {
                this.systemMenu.getComponentAtIndex(4).setEnabled(false);
            }
            this.systemMenu.getComponentAtIndex(3).setEnabled(!bl2);
        } else if (string.equals("maximizable")) {
            if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.add(this.maximizeButton);
            } else {
                this.remove(this.maximizeButton);
            }
            this.revalidate();
            this.repaint();
        } else if (string.equals("iconable")) {
            if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.add(this.minimizeButton);
            } else {
                this.remove(this.minimizeButton);
            }
            this.revalidate();
            this.repaint();
        } else if (string.equals("title")) {
            this.repaint();
        }
    }

    public MotifInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.iFrame = jInternalFrame;
        this.setPreferredSize(new Dimension(100, 19));
        this.systemMenu = new JPopupMenu(this){
            private final MotifInternalFrameTitlePane this$0;
            {
                this.this$0 = motifInternalFrameTitlePane;
            }

            public void show(Component component, int n2, int n3) {
                if (!this.this$0.iFrame.isIconifiable()) {
                    this.this$0.systemMenu.getComponentAtIndex(3).setEnabled(false);
                }
                if (!this.this$0.iFrame.isMaximizable()) {
                    this.this$0.systemMenu.getComponentAtIndex(4).setEnabled(false);
                }
                if (!this.this$0.iFrame.isMaximizable() && !this.this$0.iFrame.isIconifiable()) {
                    this.this$0.systemMenu.getComponentAtIndex(0).setEnabled(false);
                }
                if (!this.this$0.iFrame.isClosable()) {
                    this.this$0.systemMenu.getComponentAtIndex(6).setEnabled(false);
                }
                super.show(component, n2, n3);
            }
        };
        JMenuItem jMenuItem = this.systemMenu.add(new JMenuItem(RESTORE_CMD));
        jMenuItem.setEnabled(this.iFrame.isIcon());
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem(MOVE_CMD));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem(SIZE_CMD));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem(ICONIFY_CMD));
        jMenuItem.setEnabled(!this.iFrame.isIcon());
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem(MAXIMIZE_CMD));
        jMenuItem.addActionListener(this);
        this.systemMenu.add(new JSeparator());
        jMenuItem = this.systemMenu.add(new JMenuItem(CLOSE_CMD));
        jMenuItem.addActionListener(this);
        this.systemButton = new SystemButton(this, null);
        this.systemButton.addActionListener(new ActionListener(this){
            private final MotifInternalFrameTitlePane this$0;
            {
                this.this$0 = motifInternalFrameTitlePane;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.systemMenu.show(this.this$0.systemButton, 0, 19);
            }
        });
        this.systemButton.addMouseListener(new MouseAdapter(this){
            private final MotifInternalFrameTitlePane this$0;
            {
                this.this$0 = motifInternalFrameTitlePane;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (this.this$0.iFrame.isClosable()) {
                        this.this$0.iFrame.doDefaultCloseAction();
                    }
                    this.this$0.systemMenu.setVisible(false);
                }
            }
        });
        this.minimizeButton = new MinimizeButton(this, null);
        this.minimizeButton.addActionListener(this);
        this.minimizeButton.setActionCommand(ICONIFY_CMD);
        this.maximizeButton = new MaximizeButton(this, null);
        this.maximizeButton.addActionListener(this);
        this.maximizeButton.setActionCommand(MAXIMIZE_CMD);
        this.title = new Title(this, this.iFrame.getTitle());
        this.title.setFont(defaultTitleFont);
        this.setLayout(this);
        this.add(this.systemButton);
        this.add(this.title);
        this.add(this.minimizeButton);
        this.add(this.maximizeButton);
        this.iFrame.addPropertyChangeListener(this);
    }

    JPopupMenu getSystemMenu() {
        return this.systemMenu;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 19);
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 19);
    }

    void setColors(Color color, Color color2, Color color3) {
        this.color = color;
        this.highlight = color2;
        this.shadow = color3;
    }

    private abstract class FrameButton
    extends JButton {
        private final MotifInternalFrameTitlePane this$0;

        public void requestFocus() {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        FrameButton(MotifInternalFrameTitlePane motifInternalFrameTitlePane) {
            this.this$0 = motifInternalFrameTitlePane;
            this.setFocusPainted(false);
            this.setBorderPainted(false);
        }

        public Dimension getMinimumSize() {
            return buttonDimension;
        }

        public Dimension getPreferredSize() {
            return buttonDimension;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n2 = dimension.width - 1;
            int n3 = dimension.height - 1;
            graphics.setColor(this.this$0.color);
            graphics.fillRect(1, 1, dimension.width, dimension.height);
            boolean bl2 = this.getModel().isPressed();
            graphics.setColor(bl2 ? this.this$0.shadow : this.this$0.highlight);
            graphics.drawLine(0, 0, n2, 0);
            graphics.drawLine(0, 0, 0, n3);
            graphics.setColor(bl2 ? this.this$0.highlight : this.this$0.shadow);
            graphics.drawLine(1, n3, n2, n3);
            graphics.drawLine(n2, 1, n2, n3);
        }
    }

    private class MaximizeButton
    extends FrameButton {
        private final MotifInternalFrameTitlePane this$0;

        private MaximizeButton(MotifInternalFrameTitlePane motifInternalFrameTitlePane) {
            this.this$0 = motifInternalFrameTitlePane;
            super(motifInternalFrameTitlePane);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n2 = 14;
            boolean bl2 = this.this$0.iFrame.isMaximum();
            graphics.setColor(bl2 ? this.this$0.shadow : this.this$0.highlight);
            graphics.drawLine(4, 4, 4, n2);
            graphics.drawLine(4, 4, n2, 4);
            graphics.setColor(bl2 ? this.this$0.highlight : this.this$0.shadow);
            graphics.drawLine(5, n2, n2, n2);
            graphics.drawLine(n2, 5, n2, n2);
        }

        MaximizeButton(MotifInternalFrameTitlePane motifInternalFrameTitlePane, 1 var2_2) {
            this(motifInternalFrameTitlePane);
        }
    }

    private class MinimizeButton
    extends FrameButton {
        private final MotifInternalFrameTitlePane this$0;

        private MinimizeButton(MotifInternalFrameTitlePane motifInternalFrameTitlePane) {
            this.this$0 = motifInternalFrameTitlePane;
            super(motifInternalFrameTitlePane);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(this.this$0.highlight);
            graphics.drawLine(7, 8, 7, 11);
            graphics.drawLine(7, 8, 10, 8);
            graphics.setColor(this.this$0.shadow);
            graphics.drawLine(8, 11, 10, 11);
            graphics.drawLine(11, 9, 11, 11);
        }

        MinimizeButton(MotifInternalFrameTitlePane motifInternalFrameTitlePane, 1 var2_2) {
            this(motifInternalFrameTitlePane);
        }
    }

    private class SystemButton
    extends FrameButton {
        private final MotifInternalFrameTitlePane this$0;

        public void requestFocus() {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        private SystemButton(MotifInternalFrameTitlePane motifInternalFrameTitlePane) {
            this.this$0 = motifInternalFrameTitlePane;
            super(motifInternalFrameTitlePane);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(this.this$0.highlight);
            graphics.drawLine(4, 8, 4, 11);
            graphics.drawLine(4, 8, 14, 8);
            graphics.setColor(this.this$0.shadow);
            graphics.drawLine(5, 11, 14, 11);
            graphics.drawLine(14, 9, 14, 11);
        }

        SystemButton(MotifInternalFrameTitlePane motifInternalFrameTitlePane, 1 var2_2) {
            this(motifInternalFrameTitlePane);
        }
    }

    private class Title
    extends FrameButton {
        private final MotifInternalFrameTitlePane this$0;

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.this$0.iFrame.isSelected()) {
                graphics.setColor(UIManager.getColor("activeCaptionText"));
            } else {
                graphics.setColor(UIManager.getColor("inactiveCaptionText"));
            }
            Dimension dimension = this.getSize();
            String string = this.this$0.iFrame.getTitle();
            if (string != null) {
                MotifGraphicsUtils.drawStringInRect(graphics, string, 0, 0, dimension.width, dimension.height, 0);
            }
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        Title(MotifInternalFrameTitlePane motifInternalFrameTitlePane, String string) {
            this.this$0 = motifInternalFrameTitlePane;
            super(motifInternalFrameTitlePane);
            this.setText(string);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createBevelBorder(0, UIManager.getColor("activeCaptionBorder"), UIManager.getColor("inactiveCaptionBorder")));
            this.addMouseMotionListener(new MouseMotionListener(this){
                private final Title this$1;
                {
                    this.this$1 = title;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
            this.addMouseListener(new MouseListener(this){
                private final Title this$1;
                {
                    this.this$1 = title;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
        }
    }
}

