/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public abstract class AbstractMidiDeviceProvider
extends MidiDeviceProvider {
    private static boolean enabled;

    abstract int getNumDevices();

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    synchronized void readDeviceInfos() {
        int n2;
        Info[] infoArray = this.getInfoCache();
        MidiDevice[] midiDeviceArray = this.getDeviceCache();
        if (!enabled) {
            if (infoArray == null || infoArray.length != 0) {
                this.setInfoCache(new Info[0]);
            }
            if (midiDeviceArray == null || midiDeviceArray.length != 0) {
                this.setDeviceCache(new MidiDevice[0]);
            }
            return;
        }
        int n3 = infoArray == null ? -1 : infoArray.length;
        if (n3 != (n2 = this.getNumDevices())) {
            int n4;
            Info[] infoArray2 = new Info[n2];
            MidiDevice[] midiDeviceArray2 = new MidiDevice[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                Info info = this.createInfo(n4);
                if (infoArray != null) {
                    for (int i2 = 0; i2 < infoArray.length; ++i2) {
                        Info info2 = infoArray[i2];
                        if (info2 == null || !info2.equalStrings(info)) continue;
                        infoArray2[n4] = info2;
                        info2.setIndex(n4);
                        infoArray[i2] = null;
                        midiDeviceArray2[n4] = midiDeviceArray[i2];
                        midiDeviceArray[i2] = null;
                        break;
                    }
                }
                if (infoArray2[n4] != null) continue;
                infoArray2[n4] = info;
            }
            if (infoArray != null) {
                for (n4 = 0; n4 < infoArray.length; ++n4) {
                    if (infoArray[n4] == null) continue;
                    infoArray[n4].setIndex(-1);
                }
            }
            this.setInfoCache(infoArray2);
            this.setDeviceCache(midiDeviceArray2);
        }
    }

    abstract Info[] getInfoCache();

    abstract Info createInfo(int var1);

    abstract void setInfoCache(Info[] var1);

    abstract MidiDevice[] getDeviceCache();

    abstract void setDeviceCache(MidiDevice[] var1);

    public MidiDevice.Info[] getDeviceInfo() {
        this.readDeviceInfos();
        Info[] infoArray = this.getInfoCache();
        MidiDevice.Info[] infoArray2 = new MidiDevice.Info[infoArray.length];
        System.arraycopy(infoArray, 0, infoArray2, 0, infoArray.length);
        return infoArray2;
    }

    abstract MidiDevice createDevice(Info var1);

    public MidiDevice getDevice(MidiDevice.Info info) {
        if (info instanceof Info) {
            this.readDeviceInfos();
            MidiDevice[] midiDeviceArray = this.getDeviceCache();
            Info[] infoArray = this.getInfoCache();
            Info info2 = (Info)info;
            int n2 = info2.getIndex();
            if (n2 >= 0 && n2 < midiDeviceArray.length && infoArray[n2] == info) {
                if (midiDeviceArray[n2] == null) {
                    midiDeviceArray[n2] = this.createDevice(info2);
                }
                if (midiDeviceArray[n2] != null) {
                    return midiDeviceArray[n2];
                }
            }
        }
        throw new IllegalArgumentException("MidiDevice " + info.toString() + " not supported by this provider.");
    }

    static class Info
    extends MidiDevice.Info {
        private int index;

        int getIndex() {
            return this.index;
        }

        void setIndex(int n2) {
            this.index = n2;
        }

        boolean equalStrings(Info info) {
            return info != null && this.getName().equals(info.getName()) && this.getVendor().equals(info.getVendor()) && this.getDescription().equals(info.getDescription()) && this.getVersion().equals(info.getVersion());
        }

        Info(String string, String string2, String string3, String string4, int n2) {
            super(string, string2, string3, string4);
            this.index = n2;
        }
    }
}

