/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.util.Debug;

public final class AccessController {
    private AccessController() {
    }

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return new AccessControlContext(null, true);
        }
        return accessControlContext.optimize();
    }

    static native AccessControlContext getInheritedAccessControlContext();

    private static native AccessControlContext getStackAccessControlContext();

    public static void checkPermission(Permission permission) throws AccessControlException {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            if (debug != null) {
                if (Debug.isOn("stack")) {
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                if (Debug.isOn("domain")) {
                    debug.println("domain (context is null)");
                }
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }

    public static native Object doPrivileged(PrivilegedAction var0);

    public static native Object doPrivileged(PrivilegedExceptionAction var0) throws PrivilegedActionException;

    public static native Object doPrivileged(PrivilegedAction var0, AccessControlContext var1);

    public static native Object doPrivileged(PrivilegedExceptionAction var0, AccessControlContext var1) throws PrivilegedActionException;
}

