/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;

public final class PropertyPermission
extends BasicPermission {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    int getMask() {
        return this.mask;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private void init(int n2) {
        if ((n2 & 3) != n2) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = n2;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(PropertyPermission.getMask(this.actions));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)object;
        return this.mask == propertyPermission.mask && this.getName().equals(propertyPermission.getName());
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = PropertyPermission.getActions(this.mask);
        }
        return this.actions;
    }

    static String getActions(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if ((n2 & 1) == 1) {
            bl2 = true;
            stringBuffer.append("read");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("write");
        }
        return stringBuffer.toString();
    }

    private static int getMask(String string) {
        int n2 = 0;
        if (string == null) {
            return n2;
        }
        if (string == "read") {
            return 1;
        }
        if (string == "write") {
            return 2;
        }
        if (string == "read,write") {
            return 3;
        }
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        if (n3 < 0) {
            return n2;
        }
        while (n3 != -1) {
            int n4;
            char c2;
            while (n3 != -1 && ((c2 = cArray[n3]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --n3;
            }
            if (!(n3 < 3 || cArray[n3 - 3] != 'r' && cArray[n3 - 3] != 'R' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 'a' && cArray[n3 - 1] != 'A' || cArray[n3] != 'd' && cArray[n3] != 'D')) {
                n4 = 4;
                n2 |= 1;
            } else if (!(n3 < 4 || cArray[n3 - 4] != 'w' && cArray[n3 - 4] != 'W' || cArray[n3 - 3] != 'r' && cArray[n3 - 3] != 'R' || cArray[n3 - 2] != 'i' && cArray[n3 - 2] != 'I' || cArray[n3 - 1] != 't' && cArray[n3 - 1] != 'T' || cArray[n3] != 'e' && cArray[n3] != 'E')) {
                n4 = 5;
                n2 |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl2 = false;
            while (n3 >= n4 && !bl2) {
                switch (cArray[n3 - n4]) {
                    case ',': {
                        bl2 = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n3;
            }
            n3 -= n4;
        }
        return n2;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        return (this.mask & propertyPermission.mask) == propertyPermission.mask && super.implies(propertyPermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }

    public PropertyPermission(String string, String string2) {
        super(string, string2);
        this.init(PropertyPermission.getMask(string2));
    }
}

