/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import sun.misc.SoftCache;

public abstract class ResourceBundle {
    private static final ResourceCacheKey cacheKey = new ResourceCacheKey(null);
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;
    private static final int MAX_BUNDLES_SEARCHED = 3;
    private static final Hashtable underConstruction = new Hashtable(3, 1.0f);
    private static final Object NOT_FOUND = new Object();
    private static SoftCache cacheList = new SoftCache(25, 1.0f);
    private static ReferenceQueue referenceQueue = new ReferenceQueue();
    protected ResourceBundle parent = null;
    private Locale locale = null;
    static Class class$java$util$ResourceBundle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            Collection collection = underConstruction.values();
            Thread thread = Thread.currentThread();
            while (collection.remove(thread)) {
            }
        }
    }

    private static native Class[] getClassContext();

    private static ClassLoader getLoader() {
        ClassLoader classLoader;
        Class[] classArray = ResourceBundle.getClassContext();
        Class clazz = classArray[2];
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    static ReferenceQueue access$100() {
        return referenceQueue;
    }

    public abstract Enumeration getKeys();

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public final Object getObject(String string) {
        Object object = this.handleGetObject(string);
        if (object == null) {
            if (this.parent != null) {
                object = this.parent.getObject(string);
            }
            if (object == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + string, this.getClass().getName(), string);
            }
        }
        return object;
    }

    protected abstract Object handleGetObject(String var1);

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    private void setLocale(String string, String string2) {
        if (string.length() == string2.length()) {
            this.locale = new Locale("", "");
        } else if (string.length() < string2.length()) {
            int n2 = string.length();
            String string3 = string2.substring(n2 + 1);
            if ((n2 = string3.indexOf(95)) == -1) {
                this.locale = new Locale(string3, "", "");
                return;
            }
            String string4 = string3.substring(0, n2);
            if ((n2 = (string3 = string3.substring(n2 + 1)).indexOf(95)) == -1) {
                this.locale = new Locale(string4, string3, "");
                return;
            }
            String string5 = string3.substring(0, n2);
            string3 = string3.substring(n2 + 1);
            this.locale = new Locale(string4, string5, string3);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void throwMissingResourceException(String string, Locale locale) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + string + ", locale " + locale, string + "_" + locale, "");
    }

    public static final ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundleImpl(string, Locale.getDefault(), ResourceBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundleImpl(string, locale, ResourceBundle.getLoader());
    }

    private static Vector calculateBundleNames(String string, Locale locale) {
        String string2;
        int n2;
        String string3;
        int n3;
        Vector vector = new Vector(3);
        String string4 = locale.getLanguage();
        int n4 = string4.length();
        if (n4 + (n3 = (string3 = locale.getCountry()).length()) + (n2 = (string2 = locale.getVariant()).length()) == 0) {
            return vector;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('_');
        stringBuffer.append(string4);
        if (n4 > 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n3 + n2 == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string3);
        if (n3 > 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n2 == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string2);
        vector.addElement(stringBuffer.toString());
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundleInCache(ClassLoader classLoader, String string, Locale locale) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(classLoader, string, locale);
            Object object = cacheList.get(cacheKey);
            cacheKey.clear();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadBundle(ClassLoader classLoader, String string, Locale locale) {
        Object object;
        String string2 = string.replace('/', '.');
        try {
            object = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
            if ((class$java$util$ResourceBundle == null ? (class$java$util$ResourceBundle = ResourceBundle.class$("java.util.ResourceBundle")) : class$java$util$ResourceBundle).isAssignableFrom((Class)object)) {
                Object object2 = ((Class)object).newInstance();
                Object object3 = ResourceBundle.findBundleInCache(classLoader, string, locale);
                if (object3 != null) {
                    return object3;
                }
                return object2;
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        object = string.replace('.', '/') + ".properties";
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(classLoader, (String)object){
            private final ClassLoader val$loader;
            private final String val$resName;

            public Object run() {
                if (this.val$loader != null) {
                    return this.val$loader.getResourceAsStream(this.val$resName);
                }
                return ClassLoader.getSystemResourceAsStream(this.val$resName);
            }
            {
                this.val$loader = classLoader;
                this.val$resName = string;
            }
        });
        if (inputStream != null) {
            inputStream = new BufferedInputStream(inputStream);
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
                return propertyResourceBundle;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putBundleInCache(ClassLoader classLoader, String string, Locale locale, Object object) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(classLoader, string, locale);
            cacheList.put(cacheKey.clone(), object);
            underConstruction.remove(cacheKey);
            cacheKey.clear();
            cacheList.notifyAll();
        }
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(string, locale, classLoader);
    }

    private static ResourceBundle getBundleImpl(String string, Locale locale, ClassLoader classLoader) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = string;
        String string3 = locale.toString();
        if (string3.length() > 0) {
            string2 = string2 + "_" + string3;
        } else if (locale.getVariant().length() > 0) {
            string2 = string2 + "___" + locale.getVariant();
        }
        Locale locale2 = Locale.getDefault();
        Object object = ResourceBundle.findBundleInCache(classLoader, string2, locale2);
        if (object == NOT_FOUND) {
            ResourceBundle.throwMissingResourceException(string, locale);
        } else if (object != null) {
            return (ResourceBundle)object;
        }
        Object object2 = NOT_FOUND;
        try {
            boolean bl2;
            Object object3 = ResourceBundle.findBundle(classLoader, string, locale2, string, null);
            if (object3 == null) {
                ResourceBundle.putBundleInCache(classLoader, string, locale2, NOT_FOUND);
                object3 = NOT_FOUND;
            }
            Vector vector = ResourceBundle.calculateBundleNames(string, locale);
            Vector vector2 = new Vector(3);
            boolean bl3 = bl2 = object3 != NOT_FOUND && vector.size() == 0;
            if (!bl2) {
                object2 = object3;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    string2 = (String)vector.elementAt(i2);
                    object = ResourceBundle.findBundle(classLoader, string2, locale2, string, object2);
                    vector2.addElement(object);
                    if (object == null) continue;
                    object2 = object;
                    bl2 = true;
                }
            }
            object2 = object3;
            if (!bl2) {
                Vector vector3 = ResourceBundle.calculateBundleNames(string, locale2);
                for (int i3 = 0; i3 < vector3.size() && !vector.contains(string2 = (String)vector3.elementAt(i3)); ++i3) {
                    object = ResourceBundle.findBundle(classLoader, string2, locale2, string, object2);
                    if (object != null) {
                        object2 = object;
                        continue;
                    }
                    ResourceBundle.putBundleInCache(classLoader, string2, locale2, object2);
                }
            }
            object2 = ResourceBundle.propagate(classLoader, vector, vector2, locale2, object2);
        }
        catch (Exception exception) {
            ResourceBundle.cleanUpConstructionList();
            ResourceBundle.throwMissingResourceException(string, locale);
        }
        catch (Error error) {
            ResourceBundle.cleanUpConstructionList();
            throw error;
        }
        if (object2 == NOT_FOUND) {
            ResourceBundle.throwMissingResourceException(string, locale);
        }
        return (ResourceBundle)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundle(ClassLoader classLoader, String string, Locale locale, String string2, Object object) {
        Object object2;
        Object object3;
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            boolean bl2;
            object3 = referenceQueue.poll();
            while (object3 != null) {
                cacheList.remove(((LoaderReference)object3).getCacheKey());
                object3 = referenceQueue.poll();
            }
            cacheKey.setKeyValues(classLoader, string, locale);
            object2 = cacheList.get(cacheKey);
            if (object2 != null) {
                cacheKey.clear();
                return object2;
            }
            Thread thread = (Thread)underConstruction.get(cacheKey);
            boolean bl3 = bl2 = thread != null && thread != Thread.currentThread();
            if (bl2) {
                while (bl2) {
                    cacheKey.clear();
                    try {
                        cacheList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    cacheKey.setKeyValues(classLoader, string, locale);
                    bl2 = underConstruction.containsKey(cacheKey);
                }
                object2 = cacheList.get(cacheKey);
                if (object2 != null) {
                    cacheKey.clear();
                    return object2;
                }
            }
            Object object4 = cacheKey.clone();
            underConstruction.put(object4, Thread.currentThread());
            cacheKey.clear();
        }
        object2 = ResourceBundle.loadBundle(classLoader, string, locale);
        if (object2 != null) {
            boolean bl4;
            object3 = cacheList;
            synchronized (object3) {
                cacheKey.setKeyValues(classLoader, string, locale);
                bl4 = underConstruction.get(cacheKey) == Thread.currentThread();
                cacheKey.clear();
            }
            if (bl4) {
                object3 = (ResourceBundle)object2;
                if (object != NOT_FOUND && ((ResourceBundle)object3).parent == null) {
                    ((ResourceBundle)object3).setParent((ResourceBundle)object);
                }
                super.setLocale(string2, string);
                ResourceBundle.putBundleInCache(classLoader, string, locale, object2);
            }
        }
        return object2;
    }

    private static Object propagate(ClassLoader classLoader, Vector vector, Vector vector2, Locale locale, Object object) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            String string = (String)vector.elementAt(i2);
            Object object2 = vector2.elementAt(i2);
            if (object2 == null) {
                ResourceBundle.putBundleInCache(classLoader, string, locale, object);
                continue;
            }
            object = object2;
        }
        return object;
    }

    private static final class LoaderReference
    extends WeakReference {
        private ResourceCacheKey cacheKey;

        ResourceCacheKey getCacheKey() {
            return this.cacheKey;
        }

        LoaderReference(Object object, ReferenceQueue referenceQueue, ResourceCacheKey resourceCacheKey) {
            super(object, referenceQueue);
            this.cacheKey = resourceCacheKey;
        }
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private LoaderReference loaderRef;
        private String searchName;
        private Locale defaultLocale;
        private int hashCodeCache;

        public int hashCode() {
            return this.hashCodeCache;
        }

        private ResourceCacheKey() {
        }

        public void clear() {
            this.setKeyValues(null, "", null);
        }

        public Object clone() {
            try {
                ResourceCacheKey resourceCacheKey = (ResourceCacheKey)super.clone();
                if (this.loaderRef != null) {
                    resourceCacheKey.loaderRef = new LoaderReference(this.loaderRef.get(), ResourceBundle.access$100(), resourceCacheKey);
                }
                return resourceCacheKey;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            try {
                ResourceCacheKey resourceCacheKey = (ResourceCacheKey)object;
                if (this.hashCodeCache != resourceCacheKey.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(resourceCacheKey.searchName)) {
                    return false;
                }
                if (this.defaultLocale == null ? resourceCacheKey.defaultLocale != null : !this.defaultLocale.equals(resourceCacheKey.defaultLocale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return resourceCacheKey.loaderRef == null;
                }
                Object object2 = this.loaderRef.get();
                return resourceCacheKey.loaderRef != null && object2 != null && object2 == resourceCacheKey.loaderRef.get();
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        ResourceCacheKey(1 var1_1) {
            this();
        }

        public void setKeyValues(ClassLoader classLoader, String string, Locale locale) {
            this.searchName = string;
            this.hashCodeCache = string.hashCode();
            this.defaultLocale = locale;
            if (locale != null) {
                this.hashCodeCache ^= locale.hashCode();
            }
            if (classLoader == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new LoaderReference(classLoader, ResourceBundle.access$100(), this);
                this.hashCodeCache ^= classLoader.hashCode();
            }
        }
    }
}

