/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.VolatileImage;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.AncestorNotifier;
import javax.swing.Autoscroller;
import javax.swing.CellRendererPane;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.LegacyGlueFocusTraversalPolicy;
import javax.swing.Popup;
import javax.swing.RepaintManager;
import javax.swing.SwingGraphics;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;

public abstract class JComponent
extends Container
implements Serializable {
    private static final String uiClassID = "ComponentUI";
    private static final Hashtable readObjectCallbacks = new Hashtable(1);
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private static boolean suppressDropSupport;
    private static boolean checkedSuppressDropSupport;
    private static final int NOT_OBSCURED = 0;
    private static final int PARTIALLY_OBSCURED = 1;
    private static final int COMPLETELY_OBSCURED = 2;
    private Dimension preferredSize;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private Float alignmentX;
    private Float alignmentY;
    private AncestorNotifier ancestorNotifier;
    Rectangle _bounds = new Rectangle();
    protected transient ComponentUI ui;
    protected EventListenerList listenerList = new EventListenerList();
    private Hashtable clientProperties;
    private VetoableChangeSupport vetoableChangeSupport;
    private Autoscroller autoscroller;
    private Border border;
    private int flags;
    private TransferHandler transfer;
    private InputVerifier inputVerifier = null;
    private boolean verifyInputWhenFocusTarget = true;
    private transient Rectangle tmpRect;
    transient Component paintingChild;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int UNDEFINED_CONDITION = -1;
    private static final String KEYBOARD_BINDINGS_KEY = "_KeyboardBindings";
    private static final String WHEN_IN_FOCUSED_WINDOW_BINDINGS = "_WhenInFocusedWindow";
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    private static final String NEXT_FOCUS = "nextFocus";
    private static final int IS_DOUBLE_BUFFERED = 0;
    private static final int ANCESTOR_USING_BUFFER = 1;
    private static final int IS_PAINTING_TILE = 2;
    private static final int IS_OPAQUE = 3;
    private static final int KEY_EVENTS_ENABLED = 4;
    private static final int FOCUS_INPUTMAP_CREATED = 5;
    private static final int ANCESTOR_INPUTMAP_CREATED = 6;
    private static final int WIF_INPUTMAP_CREATED = 7;
    private static final int ACTIONMAP_CREATED = 8;
    private static final int CREATED_DOUBLE_BUFFER = 9;
    private static final int IS_PRINTING = 11;
    private static final int IS_PRINTING_ALL = 12;
    private static final int IS_REPAINTING = 13;
    private static final int WRITE_OBJ_COUNTER_FIRST = 14;
    private static final int RESERVED_1 = 15;
    private static final int RESERVED_2 = 16;
    private static final int RESERVED_3 = 17;
    private static final int RESERVED_4 = 18;
    private static final int RESERVED_5 = 19;
    private static final int RESERVED_6 = 20;
    private static final int WRITE_OBJ_COUNTER_LAST = 21;
    private static final int REQUEST_FOCUS_DISABLED = 22;
    private InputMap focusInputMap;
    private InputMap ancestorInputMap;
    private ComponentInputMap windowInputMap;
    private ActionMap actionMap;
    private static final String defaultLocale = "JComponent.defaultLocale";
    protected AccessibleContext accessibleContext = null;
    private static final String htmlKey = "html";
    private Object htmlView;
    private SwingPropertyChangeSupport changeSupport;
    private Rectangle paintImmediatelyClip = new Rectangle(0, 0, 0, 0);
    static Class class$javax$swing$JComponent$KeyboardState;
    static Class class$javax$swing$event$AncestorListener;
    static Class class$java$beans$VetoableChangeListener;
    static Class class$java$beans$PropertyChangeListener;

    public float getAlignmentX() {
        return this.alignmentX != null ? this.alignmentX.floatValue() : super.getAlignmentX();
    }

    public float getAlignmentY() {
        return this.alignmentY != null ? this.alignmentY.floatValue() : super.getAlignmentY();
    }

    public int getDebugGraphicsOptions() {
        return DebugGraphics.getDebugOptions(this);
    }

    public int getHeight() {
        return this._bounds.height;
    }

    public int getWidth() {
        return this._bounds.width;
    }

    public int getX() {
        return this._bounds.x;
    }

    public int getY() {
        return this._bounds.y;
    }

    int shouldDebugGraphics() {
        return DebugGraphics.shouldComponentDebug(this);
    }

    public JComponent() {
        this.enableEvents(8L);
        this.enableSerialization();
        if (this.isManagingFocus()) {
            this.setFocusTraversalKeys(0, JComponent.getManagingFocusForwardTraversalKeys());
            this.setFocusTraversalKeys(1, JComponent.getManagingFocusBackwardTraversalKeys());
        }
        super.setLocale(JComponent.getDefaultLocale());
    }

    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("ancestor", null, this.getParent());
        this.registerWithKeyboardManager(false);
        this.registerNextFocusableComponent();
    }

    private void adjustPaintFlags() {
        JComponent jComponent = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JComponent)) continue;
            jComponent = (JComponent)container;
            if (jComponent.getFlag(1)) {
                this.setFlag(1, true);
            }
            if (jComponent.getFlag(2)) {
                this.setFlag(2, true);
            }
            if (jComponent.getFlag(11)) {
                this.setFlag(11, true);
            }
            if (!jComponent.getFlag(12)) break;
            this.setFlag(12, true);
            break;
        }
    }

    void compWriteObjectNotify() {
        byte by = JComponent.getWriteObjCounter(this);
        JComponent.setWriteObjCounter(this, (byte)(by + 1));
        if (by != 0) {
            return;
        }
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        if (this.getToolTipText() != null || this instanceof JTableHeader) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    private void deregisterNextFocusableComponent() {
        Container container;
        Component component = this.getNextFocusableComponent();
        if (component == null) {
            return;
        }
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy) {
            ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).unsetNextFocusableComponent(this, component);
        }
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    void enableSerialization() {
        this.addFocusListener(new EnableSerializationFocusListener(this, null));
    }

    public void grabFocus() {
        this.requestFocus();
    }

    private void registerNextFocusableComponent() {
        this.registerNextFocusableComponent(this.getNextFocusableComponent());
    }

    public void removeNotify() {
        super.removeNotify();
        this.firePropertyChange("ancestor", this.getParent(), null);
        this.unregisterWithKeyboardManager();
        this.deregisterNextFocusableComponent();
        if (this.getCreatedDoubleBuffer()) {
            RepaintManager.currentManager(this).resetDoubleBuffer();
            this.setCreatedDoubleBuffer(false);
        }
    }

    public void requestFocus() {
        if (this.runInputVerifier()) {
            super.requestFocus();
        }
    }

    public void resetKeyboardActions() {
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null) continue;
            inputMap.clear();
        }
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap != null) {
            actionMap.clear();
        }
    }

    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        } else {
            Runnable runnable = new Runnable(this){
                private final JComponent this$0;

                public void run() {
                    this.this$0.revalidate();
                }
                {
                    this.this$0 = jComponent;
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void unregisterWithKeyboardManager() {
        Hashtable hashtable = (Hashtable)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
        }
        this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
    }

    public void updateUI() {
    }

    boolean alwaysOnTop() {
        return false;
    }

    boolean checkIfChildObscuredBySibling() {
        return true;
    }

    public boolean getAutoscrolls() {
        return this.autoscroller != null;
    }

    boolean getCreatedDoubleBuffer() {
        return this.getFlag(9);
    }

    private static boolean getSuppressDropTarget() {
        if (!checkedSuppressDropSupport) {
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("suppressSwingDropSupport");
                    if (string != null) {
                        return Boolean.valueOf(string);
                    }
                    return Boolean.FALSE;
                }
            });
            suppressDropSupport = bl2;
            checkedSuppressDropSupport = true;
        }
        return suppressDropSupport;
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public boolean isDoubleBuffered() {
        return this.getFlag(0);
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isMaximumSizeSet() {
        return this.maximumSize != null;
    }

    public boolean isMinimumSizeSet() {
        return this.minimumSize != null;
    }

    public boolean isOpaque() {
        return this.getFlag(3);
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    boolean isPaintingOrigin() {
        return false;
    }

    public boolean isPaintingTile() {
        return this.getFlag(2);
    }

    public boolean isPreferredSizeSet() {
        return this.preferredSize != null;
    }

    public boolean isRequestFocusEnabled() {
        return !this.getFlag(22);
    }

    public boolean isValidateRoot() {
        return false;
    }

    public boolean requestDefaultFocus() {
        Container container;
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return false;
        }
        Component component = container.getFocusTraversalPolicy().getDefaultComponent(container);
        if (component != null) {
            component.requestFocus();
            return true;
        }
        return false;
    }

    public boolean requestFocusInWindow() {
        return this.runInputVerifier() ? super.requestFocusInWindow() : false;
    }

    private boolean runInputVerifier() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == this) {
            return true;
        }
        if (!this.getVerifyInputWhenFocusTarget()) {
            return true;
        }
        if (component == null || !(component instanceof JComponent)) {
            return true;
        }
        JComponent jComponent = (JComponent)component;
        InputVerifier inputVerifier = jComponent.getInputVerifier();
        if (inputVerifier == null) {
            return true;
        }
        return inputVerifier.shouldYieldFocus(jComponent);
    }

    public void setAlignmentX(float f2) {
        this.alignmentX = new Float(f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2));
    }

    public void setAlignmentY(float f2) {
        this.alignmentY = new Float(f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2));
    }

    public void setDebugGraphicsOptions(int n2) {
        DebugGraphics.setDebugOptions(this, n2);
    }

    private boolean getFlag(int n2) {
        int n3 = 1 << n2;
        return (this.flags & n3) == n3;
    }

    public boolean contains(int n2, int n3) {
        return this.ui != null ? this.ui.contains(this, n2, n3) : super.contains(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void _paintImmediately(int n2, int n3, int n4, int n5) {
        Vector vector;
        JComponent jComponent;
        block36: {
            block34: {
                block35: {
                    int n6;
                    Object object;
                    Container container;
                    int n7 = 0;
                    int n8 = 0;
                    boolean bl2 = false;
                    JComponent jComponent2 = null;
                    jComponent = this;
                    RepaintManager repaintManager = RepaintManager.currentManager(this);
                    vector = new Vector(7);
                    int n9 = -1;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    this.paintImmediatelyClip.x = n2;
                    this.paintImmediatelyClip.y = n3;
                    this.paintImmediatelyClip.width = n4;
                    this.paintImmediatelyClip.height = n5;
                    boolean bl3 = this.alwaysOnTop() && this.isOpaque();
                    JComponent jComponent3 = null;
                    for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
                        object = container instanceof JComponent ? container : null;
                        vector.addElement(container);
                        if (!bl3 && object != null && !((JComponent)object).isOptimizedDrawingEnabled()) {
                            if (container != this) {
                                if (((JComponent)object).isPaintingOrigin()) {
                                    n6 = 1;
                                } else {
                                    int n15;
                                    Component[] componentArray = container.getComponents();
                                    for (n15 = 0; n15 < componentArray.length && componentArray[n15] != jComponent3; ++n15) {
                                    }
                                    switch (((JComponent)object).getObscuredState(n15, this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height)) {
                                        case 0: {
                                            n6 = 0;
                                            break;
                                        }
                                        case 2: {
                                            return;
                                        }
                                        default: {
                                            n6 = 1;
                                            break;
                                        }
                                    }
                                }
                            } else {
                                n6 = 0;
                            }
                            if (n6 != 0) {
                                jComponent = object;
                                n9 = n10;
                                n8 = 0;
                                n7 = 0;
                                bl2 = false;
                            }
                        }
                        ++n10;
                        if (repaintManager.isDoubleBufferingEnabled() && object != null && ((JComponent)object).isDoubleBuffered()) {
                            bl2 = true;
                            jComponent2 = object;
                        }
                        if (!bl3) {
                            Rectangle rectangle = object != null ? ((JComponent)object)._bounds : container.getBounds();
                            n12 = rectangle.width;
                            n11 = rectangle.height;
                            SwingUtilities.computeIntersection(n14, n13, n12, n11, this.paintImmediatelyClip);
                            this.paintImmediatelyClip.x += rectangle.x;
                            this.paintImmediatelyClip.y += rectangle.y;
                            n7 += rectangle.x;
                            n8 += rectangle.y;
                        }
                        jComponent3 = container;
                    }
                    if (container == null) return;
                    if (container.getPeer() == null) {
                        return;
                    }
                    if (this.paintImmediatelyClip.width <= 0) return;
                    if (this.paintImmediatelyClip.height <= 0) {
                        return;
                    }
                    jComponent.setFlag(13, true);
                    this.paintImmediatelyClip.x -= n7;
                    this.paintImmediatelyClip.y -= n8;
                    if (jComponent != this) {
                        for (n6 = n9; n6 > 0; --n6) {
                            object = (Component)vector.elementAt(n6);
                            if (!(object instanceof JComponent)) continue;
                            ((JComponent)object).setPaintingChild((Component)vector.elementAt(n6 - 1));
                        }
                    }
                    try {
                        Graphics graphics;
                        try {
                            object = jComponent.getGraphics();
                            graphics = SwingGraphics.createSwingGraphics((Graphics)object);
                            ((Graphics)object).dispose();
                        }
                        catch (NullPointerException nullPointerException) {
                            graphics = null;
                            nullPointerException.printStackTrace();
                        }
                        if (graphics == null) {
                            System.err.println("In paintImmediately null graphics");
                            Object var29_29 = null;
                            if (jComponent == this) break block34;
                            break block35;
                        }
                        try {
                            boolean bl4 = false;
                            if (bl2) {
                                bl4 = this.paintDoubleBuffered(jComponent, jComponent2, graphics, this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height);
                            }
                            if (!bl4) {
                                graphics.setClip(this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height);
                                jComponent.paint(graphics);
                            }
                            break block36;
                        }
                        finally {
                            graphics.dispose();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var29_31 = null;
                        if (jComponent != this) {
                            for (int i2 = n9; i2 > 0; --i2) {
                                Component component = (Component)vector.elementAt(i2);
                                if (!(component instanceof JComponent)) continue;
                                ((JComponent)component).setPaintingChild(null);
                            }
                        }
                        vector.removeAllElements();
                        jComponent.setFlag(13, false);
                        throw throwable;
                    }
                }
                for (int i3 = n9; i3 > 0; --i3) {
                    Component component = (Component)vector.elementAt(i3);
                    if (!(component instanceof JComponent)) continue;
                    ((JComponent)component).setPaintingChild(null);
                }
            }
            vector.removeAllElements();
            jComponent.setFlag(13, false);
            return;
        }
        Object var29_30 = null;
        if (jComponent != this) {
            for (int i4 = n9; i4 > 0; --i4) {
                Component component = (Component)vector.elementAt(i4);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).setPaintingChild(null);
            }
        }
        vector.removeAllElements();
        jComponent.setFlag(13, false);
    }

    public void paintImmediately(int n2, int n3, int n4, int n5) {
        Container container;
        Container container2 = this;
        if (!this.isShowing()) {
            return;
        }
        while (!container2.isOpaque() && (container = container2.getParent()) != null) {
            Rectangle rectangle = container2 instanceof JComponent ? container2._bounds : container2.getBounds();
            n2 += rectangle.x;
            n3 += rectangle.y;
            container2 = container;
            if (container2 instanceof JComponent) continue;
        }
        if (container2 instanceof JComponent) {
            container2._paintImmediately(n2, n3, n4, n5);
        } else {
            container2.repaint(n2, n3, n4, n5);
        }
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        if (this._bounds.x == n2 && this._bounds.y == n3 && this._bounds.width == n4 && this._bounds.height == n5) {
            return;
        }
        if (this.isShowing()) {
            if (this._bounds.x + this._bounds.width > n2 && this._bounds.y + this._bounds.height > n3 && this._bounds.x < n2 + n4 && this._bounds.y < n3 + n5) {
                Rectangle[] rectangleArray = SwingUtilities.computeDifference(this.getBounds(), new Rectangle(n2, n3, n4, n5));
                Container container = this.getParent();
                int n6 = rectangleArray.length;
                for (int i2 = 0; i2 < n6; ++i2) {
                    container.repaint(rectangleArray[i2].x, rectangleArray[i2].y, rectangleArray[i2].width, rectangleArray[i2].height);
                }
            } else {
                Container container = this.getParent();
                if (container != null) {
                    container.repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                }
            }
        }
        this._bounds.setBounds(n2, n3, n4, n5);
        super.reshape(n2, n3, n4, n5);
    }

    boolean rectangleIsObscured(int n2, int n3, int n4, int n5) {
        int n6 = this.getComponentCount();
        for (int i2 = 0; i2 < n6; ++i2) {
            Component component = this.getComponent(i2);
            Rectangle rectangle = component instanceof JComponent ? ((JComponent)component)._bounds : component.getBounds();
            if (n2 < rectangle.x || n2 + n4 > rectangle.x + rectangle.width || n3 < rectangle.y || n3 + n5 > rectangle.y + rectangle.height || !component.isVisible()) continue;
            if (component instanceof JComponent) {
                return ((JComponent)component).isOpaque();
            }
            return false;
        }
        return false;
    }

    private int getObscuredState(int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Rectangle rectangle;
            boolean bl2;
            Component component = this.getComponent(i2);
            if (!component.isVisible()) continue;
            if (component instanceof JComponent) {
                bl2 = ((JComponent)component).isOpaque();
                if (!bl2 && n7 == 1) continue;
                rectangle = ((JComponent)component).getBounds(this.tmpRect);
            } else {
                rectangle = component.getBounds();
                bl2 = true;
            }
            if (bl2 && n3 >= rectangle.x && n3 + n5 <= rectangle.x + rectangle.width && n4 >= rectangle.y && n4 + n6 <= rectangle.y + rectangle.height) {
                return 2;
            }
            if (n7 != 0 || n3 + n5 <= rectangle.x || n4 + n6 <= rectangle.y || n3 >= rectangle.x + rectangle.width || n4 >= rectangle.y + rectangle.height) continue;
            n7 = 1;
        }
        return n7;
    }

    private void setFlag(int n2, boolean bl2) {
        this.flags = bl2 ? (this.flags |= 1 << n2) : (this.flags &= ~(1 << n2));
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n2, n3, n4, n5);
    }

    private void registerWithKeyboardManager(boolean bl2) {
        int n2;
        KeyStroke[] keyStrokeArray;
        InputMap inputMap = this.getInputMap(2, false);
        Hashtable hashtable = (Hashtable)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (inputMap != null) {
            keyStrokeArray = inputMap.allKeys();
            if (keyStrokeArray != null) {
                for (n2 = keyStrokeArray.length - 1; n2 >= 0; --n2) {
                    if (!bl2 || hashtable == null || hashtable.get(keyStrokeArray[n2]) == null) {
                        this.registerWithKeyboardManager(keyStrokeArray[n2]);
                    }
                    if (hashtable == null) continue;
                    hashtable.remove(keyStrokeArray[n2]);
                }
            }
        } else {
            keyStrokeArray = null;
        }
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
            hashtable.clear();
        }
        if (keyStrokeArray != null && keyStrokeArray.length > 0) {
            if (hashtable == null) {
                hashtable = new Hashtable(keyStrokeArray.length);
                this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, hashtable);
            }
            for (n2 = keyStrokeArray.length - 1; n2 >= 0; --n2) {
                hashtable.put(keyStrokeArray[n2], keyStrokeArray[n2]);
            }
        } else {
            this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
        }
    }

    public void setAutoscrolls(boolean bl2) {
        if (bl2) {
            if (this.autoscroller == null) {
                this.autoscroller = new Autoscroller(this);
            }
        } else if (this.autoscroller != null) {
            this.autoscroller.dispose();
            this.autoscroller = null;
        }
    }

    void setCreatedDoubleBuffer(boolean bl2) {
        this.setFlag(9, bl2);
    }

    public void setDoubleBuffered(boolean bl2) {
        this.setFlag(0, bl2);
    }

    public void setEnabled(boolean bl2) {
        boolean bl3 = this.isEnabled();
        super.setEnabled(bl2);
        this.firePropertyChange("enabled", bl3, bl2);
        if (bl2 != bl3) {
            this.repaint();
        }
    }

    public void setOpaque(boolean bl2) {
        boolean bl3 = this.getFlag(3);
        this.setFlag(3, bl2);
        this.firePropertyChange("opaque", bl3, bl2);
    }

    public void setRequestFocusEnabled(boolean bl2) {
        this.setFlag(22, !bl2);
    }

    public void setVerifyInputWhenFocusTarget(boolean bl2) {
        boolean bl3 = this.verifyInputWhenFocusTarget;
        this.verifyInputWhenFocusTarget = bl2;
        this.firePropertyChange("verifyInputWhenFocusTarget", bl3, bl2);
    }

    public void setVisible(boolean bl2) {
        if (bl2 != this.isVisible()) {
            super.setVisible(bl2);
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.revalidate();
        }
    }

    public boolean requestFocus(boolean bl2) {
        return this.runInputVerifier() ? super.requestFocus(bl2) : false;
    }

    protected boolean requestFocusInWindow(boolean bl2) {
        return this.runInputVerifier() ? super.requestFocusInWindow(bl2) : false;
    }

    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        super.setBackground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        super.setForeground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    public Component getNextFocusableComponent() {
        return (Component)this.getClientProperty(NEXT_FOCUS);
    }

    private void registerNextFocusableComponent(Component component) {
        if (component == null) {
            return;
        }
        Container container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (!(focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy)) {
            focusTraversalPolicy = new LegacyGlueFocusTraversalPolicy(focusTraversalPolicy);
            container.setFocusTraversalPolicy(focusTraversalPolicy);
        }
        ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).setNextFocusableComponent(this, component);
    }

    public void setNextFocusableComponent(Component component) {
        boolean bl2 = this.isDisplayable();
        if (bl2) {
            this.deregisterNextFocusableComponent();
        }
        this.putClientProperty(NEXT_FOCUS, component);
        if (bl2) {
            this.registerNextFocusableComponent(component);
        }
    }

    void setPaintingChild(Component component) {
        this.paintingChild = component;
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public Container getTopLevelAncestor() {
        for (Container container = this; container != null; container = container.getParent()) {
            if (!(container instanceof Window) && !(container instanceof Applet)) continue;
            return container;
        }
        return null;
    }

    public Dimension getMaximumSize() {
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMaximumSize(this);
        }
        return dimension != null ? dimension : super.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMinimumSize(this);
        }
        return dimension != null ? dimension : super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getPreferredSize(this);
        }
        return dimension != null ? dimension : super.getPreferredSize();
    }

    public void setMaximumSize(Dimension dimension) {
        Dimension dimension2 = this.maximumSize;
        this.maximumSize = dimension;
        this.firePropertyChange("maximumSize", dimension2, dimension);
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minimumSize;
        this.minimumSize = dimension;
        this.firePropertyChange("minimumSize", dimension2, dimension);
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension;
        this.firePropertyChange("preferredSize", dimension2, dimension);
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font != font2) {
            this.revalidate();
            this.repaint();
        }
    }

    public Graphics getGraphics() {
        if (this.shouldDebugGraphics() != 0) {
            DebugGraphics debugGraphics = new DebugGraphics(super.getGraphics(), this);
            return debugGraphics;
        }
        return super.getGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        Graphics graphics2 = this.getComponentGraphics(graphics);
        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2);
        try {
            boolean bl4;
            int n2;
            int n3;
            int n4;
            int n5;
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            Rectangle rectangle = graphics3.getClipBounds();
            if (rectangle == null) {
                n5 = 0;
                n4 = 0;
                n3 = this._bounds.width;
                n2 = this._bounds.height;
            } else {
                n4 = rectangle.x;
                n5 = rectangle.y;
                n3 = rectangle.width;
                n2 = rectangle.height;
            }
            if (n3 > this.getWidth()) {
                n3 = this.getWidth();
            }
            if (n2 > this.getHeight()) {
                n2 = this.getHeight();
            }
            if (this.getParent() != null && !(this.getParent() instanceof JComponent)) {
                this.adjustPaintFlags();
                bl2 = true;
            }
            if (!(bl4 = this.getFlag(11)) && repaintManager.isDoubleBufferingEnabled() && !this.getFlag(1) && this.isDoubleBuffered()) {
                bl3 = this.paintDoubleBuffered(this, this, graphics3, n4, n5, n3, n2);
            }
            if (!bl3) {
                if (rectangle == null) {
                    graphics3.setClip(n4, n5, n3, n2);
                }
                if (!this.rectangleIsObscured(n4, n5, n3, n2)) {
                    if (!bl4) {
                        this.paintComponent(graphics3);
                        this.paintBorder(graphics3);
                    } else {
                        this.printComponent(graphics3);
                        this.printBorder(graphics3);
                    }
                }
                if (!bl4) {
                    this.paintChildren(graphics3);
                } else {
                    this.printChildren(graphics3);
                }
            }
            Object var16_13 = null;
            graphics3.dispose();
            if (bl2) {
                this.setFlag(1, false);
                this.setFlag(2, false);
                this.setFlag(11, false);
                this.setFlag(12, false);
            }
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            graphics3.dispose();
            if (bl2) {
                this.setFlag(1, false);
                this.setFlag(2, false);
                this.setFlag(11, false);
                this.setFlag(12, false);
            }
            throw throwable;
        }
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics graphics) {
        Graphics graphics2 = null;
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                int n2;
                block35: {
                    if (n2 >= 0) break block35;
                    return;
                }
                graphics2 = SwingGraphics.createSwingGraphics(graphics);
                if (this.paintingChild != null && this.paintingChild instanceof JComponent && ((JComponent)this.paintingChild).isOpaque()) {
                    for (n2 = this.getComponentCount() - 1; n2 >= 0 && this.getComponent(n2) != this.paintingChild; --n2) {
                    }
                }
                if (this.tmpRect == null) {
                    this.tmpRect = new Rectangle();
                }
                boolean bl2 = !this.isOptimizedDrawingEnabled() && this.checkIfChildObscuredBySibling();
                Rectangle rectangle = null;
                if (bl2 && (rectangle = graphics2.getClipBounds()) == null) {
                    rectangle = new Rectangle(0, 0, this._bounds.width, this._bounds.height);
                }
                boolean bl3 = this.getFlag(11);
                while (n2 >= 0) {
                    block37: {
                        Object var17_17;
                        int n3;
                        Rectangle rectangle2;
                        boolean bl4;
                        Component component;
                        block38: {
                            component = this.getComponent(n2);
                            if (component == null || !JComponent.isLightweightComponent(component) || !component.isVisible()) break block37;
                            bl4 = component instanceof JComponent;
                            if (bl4) {
                                rectangle2 = this.tmpRect;
                                ((JComponent)component).getBounds(rectangle2);
                            } else {
                                rectangle2 = component.getBounds();
                            }
                            boolean bl5 = graphics.hitClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                            if (!bl5) break block37;
                            if (!bl2 || n2 <= 0) break block38;
                            int n4 = rectangle2.x;
                            n3 = rectangle2.y;
                            int n5 = rectangle2.width;
                            int n6 = rectangle2.height;
                            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                            if (this.getObscuredState(n2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height) == 2) break block37;
                            rectangle2.x = n4;
                            rectangle2.y = n3;
                            rectangle2.width = n5;
                            rectangle2.height = n6;
                        }
                        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics3.setColor(component.getForeground());
                        graphics3.setFont(component.getFont());
                        n3 = 0;
                        try {
                            if (bl4) {
                                if (this.getFlag(1)) {
                                    ((JComponent)component).setFlag(1, true);
                                    n3 = 1;
                                }
                                if (this.getFlag(2)) {
                                    ((JComponent)component).setFlag(2, true);
                                    n3 = 1;
                                }
                                if (!bl3) {
                                    ((JComponent)component).paint(graphics3);
                                } else if (!this.getFlag(12)) {
                                    component.print(graphics3);
                                } else {
                                    component.printAll(graphics3);
                                }
                            } else if (!bl3) {
                                component.paint(graphics3);
                            } else if (!this.getFlag(12)) {
                                component.print(graphics3);
                            } else {
                                component.printAll(graphics3);
                            }
                            var17_17 = null;
                            graphics3.dispose();
                            if (n3 != 0) {
                                ((JComponent)component).setFlag(1, false);
                                ((JComponent)component).setFlag(2, false);
                            }
                        }
                        catch (Throwable throwable) {
                            var17_17 = null;
                            graphics3.dispose();
                            if (n3 != 0) {
                                ((JComponent)component).setFlag(1, false);
                                ((JComponent)component).setFlag(2, false);
                            }
                            throw throwable;
                        }
                    }
                    --n2;
                }
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = SwingGraphics.createSwingGraphics(graphics);
            try {
                this.ui.update(graphics2, this);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        this.setFlag(11, true);
        try {
            this.paint(graphics);
        }
        finally {
            this.setFlag(11, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAll(Graphics graphics) {
        this.setFlag(12, true);
        try {
            this.print(graphics);
        }
        finally {
            this.setFlag(12, false);
        }
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    public void computeVisibleRect(Rectangle rectangle) {
        JComponent.computeVisibleRect(this, rectangle);
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Container container;
        int n2 = this.getX();
        int n3 = this.getY();
        for (container = this.getParent(); container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane); container = container.getParent()) {
            Rectangle rectangle2 = container.getBounds();
            n2 += rectangle2.x;
            n3 += rectangle2.y;
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n2;
            rectangle.y += n3;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n2;
            rectangle.y -= n3;
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.processComponentKeyEvent(keyEvent);
        }
        boolean bl2 = KeyboardState.shouldProcess(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (bl2 && this.processKeyBindings(keyEvent, keyEvent.getID() == 401)) {
            keyEvent.consume();
        }
    }

    boolean processKeyBindings(KeyEvent keyEvent, boolean bl2) {
        Container container;
        if (!SwingUtilities.isValidKeyEventForKeyBindings(keyEvent)) {
            return false;
        }
        KeyStroke keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl2);
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl2)) {
            return true;
        }
        for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
            if (container instanceof JComponent && container.processKeyBinding(keyStroke, keyEvent, 1, bl2)) {
                return true;
            }
            if (!(container instanceof JInternalFrame) || !JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl2)) continue;
            return true;
        }
        if (container != null) {
            return JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl2);
        }
        return false;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl2 = true;
        if (this.autoscroller != null && mouseEvent.getID() == 506) {
            bl2 = !this.autoscroller.timer.isRunning();
            this.autoscroller.mouseDragged(mouseEvent);
        }
        if (bl2) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    void superProcessMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableChangeSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ReadObjectCallback readObjectCallback = (ReadObjectCallback)readObjectCallbacks.get(objectInputStream);
        if (readObjectCallback == null) {
            try {
                readObjectCallback = new ReadObjectCallback(this, objectInputStream);
                readObjectCallbacks.put(objectInputStream, readObjectCallback);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        ReadObjectCallback.access$400(readObjectCallback, this);
        if (this.getToolTipText() != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        JComponent.setWriteObjCounter(this, (byte)0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.preferredSize != null ? this.preferredSize.toString() : "";
        String string2 = this.minimumSize != null ? this.minimumSize.toString() : "";
        String string3 = this.maximumSize != null ? this.maximumSize.toString() : "";
        String string4 = this.border != null ? this.border.toString() : "";
        return super.paramString() + ",alignmentX=" + this.alignmentX + ",alignmentY=" + this.alignmentY + ",border=" + string4 + ",flags=" + this.flags + ",maximumSize=" + string3 + ",minimumSize=" + string2 + ",preferredSize=" + string;
    }

    public void setToolTipText(String string) {
        String string2 = this.getToolTipText();
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string != null) {
            if (string2 == null) {
                toolTipManager.registerComponent(this);
            }
        } else {
            toolTipManager.unregisterComponent(this);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        if (this.changeSupport != null && by != by2) {
            this.changeSupport.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public void firePropertyChange(String string, char c2, char c3) {
        if (this.changeSupport != null && c2 != c3) {
            this.changeSupport.firePropertyChange(string, new Character(c2), new Character(c3));
        }
    }

    public void firePropertyChange(String string, double d2, double d3) {
        if (this.changeSupport != null && d2 != d3) {
            this.changeSupport.firePropertyChange(string, new Double(d2), new Double(d3));
        }
    }

    public void firePropertyChange(String string, float f2, float f3) {
        if (this.changeSupport != null && f2 != f3) {
            this.changeSupport.firePropertyChange(string, new Float(f2), new Float(f3));
        }
    }

    public void firePropertyChange(String string, int n2, int n3) {
        if (this.changeSupport != null && n2 != n3) {
            this.changeSupport.firePropertyChange(string, new Integer(n2), new Integer(n3));
        }
    }

    public void firePropertyChange(String string, long l2, long l3) {
        if (this.changeSupport != null && l2 != l3) {
            this.changeSupport.firePropertyChange(string, new Long(l2), new Long(l3));
        }
    }

    public void firePropertyChange(String string, short s2, short s3) {
        if (this.changeSupport != null && s2 != s3) {
            this.changeSupport.firePropertyChange(string, new Short(s2), new Short(s3));
        }
    }

    public void firePropertyChange(String string, boolean bl2, boolean bl3) {
        if (this.changeSupport != null && bl2 != bl3) {
            this.changeSupport.firePropertyChange(string, (Object)bl2, (Object)bl3);
        }
    }

    private Dictionary getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable(2);
        }
        return this.clientProperties;
    }

    static Hashtable access$300() {
        return readObjectCallbacks;
    }

    public static Locale getDefaultLocale() {
        Locale locale = (Locale)SwingUtilities.appContextGet(defaultLocale);
        if (locale == null) {
            locale = Locale.getDefault();
            JComponent.setDefaultLocale(locale);
        }
        return locale;
    }

    public static void setDefaultLocale(Locale locale) {
        SwingUtilities.appContextPut(defaultLocale, locale);
    }

    static Set getManagingFocusBackwardTraversalKeys() {
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        }
        return managingFocusBackwardTraversalKeys;
    }

    static Set getManagingFocusForwardTraversalKeys() {
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return managingFocusForwardTraversalKeys;
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public final ActionMap getActionMap() {
        return this.getActionMap(true);
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
        this.setFlag(8, true);
    }

    final ActionMap getActionMap(boolean bl2) {
        if (this.getFlag(8)) {
            return this.actionMap;
        }
        if (bl2) {
            ActionMap actionMap = new ActionMap();
            this.setActionMap(actionMap);
            return actionMap;
        }
        return null;
    }

    void componentInputMapChanged(ComponentInputMap componentInputMap) {
        InputMap inputMap;
        for (inputMap = this.getInputMap(2, false); inputMap != componentInputMap && inputMap != null; inputMap = (ComponentInputMap)inputMap.getParent()) {
        }
        if (inputMap != null) {
            this.registerWithKeyboardManager(false);
        }
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0, true);
    }

    public final InputMap getInputMap(int n2) {
        return this.getInputMap(n2, true);
    }

    public final void setInputMap(int n2, InputMap inputMap) {
        switch (n2) {
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMaps must be of type ComponentInputMap");
                }
                this.windowInputMap = (ComponentInputMap)inputMap;
                this.setFlag(7, true);
                this.registerWithKeyboardManager(false);
                break;
            }
            case 1: {
                this.ancestorInputMap = inputMap;
                this.setFlag(6, true);
                break;
            }
            case 0: {
                this.focusInputMap = inputMap;
                this.setFlag(5, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
    }

    final InputMap getInputMap(int n2, boolean bl2) {
        switch (n2) {
            case 0: {
                if (this.getFlag(5)) {
                    return this.focusInputMap;
                }
                if (!bl2) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n2, inputMap);
                return inputMap;
            }
            case 1: {
                if (this.getFlag(6)) {
                    return this.ancestorInputMap;
                }
                if (!bl2) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n2, inputMap);
                return inputMap;
            }
            case 2: {
                if (this.getFlag(7)) {
                    return this.windowInputMap;
                }
                if (!bl2) break;
                ComponentInputMap componentInputMap = new ComponentInputMap(this);
                this.setInputMap(n2, componentInputMap);
                return componentInputMap;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
        return null;
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = this.inputVerifier;
        this.inputVerifier = inputVerifier;
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    static byte getWriteObjCounter(JComponent jComponent) {
        return (byte)(jComponent.flags >> 14 & 0xFF);
    }

    static void setWriteObjCounter(JComponent jComponent, byte by) {
        jComponent.flags = jComponent.flags & 0xFFC03FFF | by << 14;
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this);
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        int[] nArray = new int[3];
        KeyStroke[][] keyStrokeArrayArray = new KeyStroke[3][];
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            keyStrokeArrayArray[i2] = inputMap != null ? inputMap.allKeys() : null;
            nArray[i2] = keyStrokeArrayArray[i2] != null ? keyStrokeArrayArray[i2].length : 0;
        }
        KeyStroke[] keyStrokeArray = new KeyStroke[nArray[0] + nArray[1] + nArray[2]];
        int n2 = 0;
        for (int i3 = 0; i3 < 3; ++i3) {
            if (nArray[i3] <= 0) continue;
            System.arraycopy(keyStrokeArrayArray[i3], 0, keyStrokeArray, n2, nArray[i3]);
            n2 += nArray[i3];
        }
        return keyStrokeArray;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null || inputMap.get(keyStroke) == null) continue;
            return i2;
        }
        return -1;
    }

    private void registerWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().registerKeyStroke(keyStroke, this);
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null) continue;
            Object object = inputMap.get(keyStroke);
            if (actionMap != null && object != null) {
                actionMap.remove(object);
            }
            inputMap.remove(keyStroke);
        }
    }

    private void unregisterWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().unregisterKeyStroke(keyStroke, this);
    }

    public TransferHandler getTransferHandler() {
        return this.transfer;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        DropTarget dropTarget;
        TransferHandler transferHandler2 = this.transfer;
        this.transfer = transferHandler;
        if (!JComponent.getSuppressDropTarget() && ((dropTarget = this.getDropTarget()) == null || dropTarget instanceof UIResource)) {
            if (transferHandler == null) {
                this.setDropTarget(null);
            } else if (!GraphicsEnvironment.isHeadless()) {
                this.setDropTarget(new TransferHandler.SwingDropTarget(this));
            }
        }
        this.firePropertyChange("transferHandler", transferHandler2, this.transfer);
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        this.firePropertyChange("border", border2, border);
        if (border != border2) {
            if (border == null || border2 == null || !border.getBorderInsets(this).equals(border2.getBorderInsets(this))) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public AncestorListener[] getAncestorListeners() {
        if (this.ancestorNotifier == null) {
            return new AncestorListener[0];
        }
        return this.ancestorNotifier.getAncestorListeners();
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            this.ancestorNotifier = new AncestorNotifier(this);
        }
        this.ancestorNotifier.addAncestorListener(ancestorListener);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            return;
        }
        this.ancestorNotifier.removeAncestorListener(ancestorListener);
        if (this.ancestorNotifier.listenerList.getListenerList().length == 0) {
            this.ancestorNotifier.removeAllListeners();
            this.ancestorNotifier = null;
        }
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    static boolean processKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl2) {
        while (true) {
            if (KeyboardManager.getCurrentManager().fireKeyboardAction(keyEvent, bl2, container)) {
                return true;
            }
            if (!(container instanceof Popup.HeavyWeightWindow)) break;
            container = ((Window)container).getOwner();
        }
        return false;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.ui != null && DebugGraphics.debugComponentCount() != 0 && this.shouldDebugGraphics() != 0 && !(graphics instanceof DebugGraphics)) {
            if (graphics instanceof SwingGraphics) {
                if (!(((SwingGraphics)graphics).subGraphics() instanceof DebugGraphics)) {
                    DebugGraphics debugGraphics = new DebugGraphics(((SwingGraphics)graphics).subGraphics(), this);
                    graphics2 = SwingGraphics.createSwingGraphics(debugGraphics);
                    ((Graphics)debugGraphics).dispose();
                }
            } else {
                graphics2 = new DebugGraphics(graphics, this);
            }
        }
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        return graphics2;
    }

    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.border != null) {
            if (this.border instanceof AbstractBorder) {
                return ((AbstractBorder)this.border).getBorderInsets(this, insets);
            }
            return this.border.getBorderInsets(this);
        }
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
        } else {
            JComponent.computeVisibleRect(container, rectangle);
            rectangle.x -= rectangle2.x;
            rectangle.y -= rectangle2.y;
            SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        }
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap == null) {
            return null;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            Object object;
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null || (object = inputMap.get(keyStroke)) == null) continue;
            Action action = actionMap.get(object);
            if (action instanceof ActionStandin) {
                return ActionStandin.access$000((ActionStandin)action);
            }
            return action;
        }
        return null;
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        InputMap inputMap = this.getInputMap(n2, false);
        ActionMap actionMap = this.getActionMap(false);
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public final Object getClientProperty(Object object) {
        if (this.clientProperties == null) {
            return null;
        }
        if (object == htmlKey) {
            return this.htmlView;
        }
        return this.getClientProperties().get(object);
    }

    public final void putClientProperty(Object object, Object object2) {
        if (object2 == null && this.clientProperties == null) {
            return;
        }
        Object object3 = this.getClientProperties().get(object);
        if (object2 != null) {
            if (object == htmlKey) {
                this.htmlView = object2;
            } else {
                this.getClientProperties().put(object, object2);
                this.firePropertyChange(object.toString(), object3, object2);
            }
        } else if (object3 != null) {
            this.getClientProperties().remove(object);
            this.firePropertyChange(object.toString(), object3, object2);
        } else if (object == htmlKey) {
            this.htmlView = null;
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener[] eventListenerArray = clazz == (class$javax$swing$event$AncestorListener == null ? (class$javax$swing$event$AncestorListener = JComponent.class$("javax.swing.event.AncestorListener")) : class$javax$swing$event$AncestorListener) ? this.getAncestorListeners() : (clazz == (class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = JComponent.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener) ? this.getVetoableChangeListeners() : (clazz == (class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = JComponent.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) ? this.getPropertyChangeListeners() : this.listenerList.getListeners(clazz)));
        if (eventListenerArray.length == 0) {
            return super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n2) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n2);
    }

    private boolean paintDoubleBuffered(JComponent jComponent, Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        boolean bl2 = false;
        Image image = null;
        if (repaintManager.useVolatileDoubleBuffer() && (image = repaintManager.getVolatileOffscreenBuffer(component, n4, n5)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            VolatileImage volatileImage = (VolatileImage)image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            for (int i2 = 0; !bl2 && i2 < 2; ++i2) {
                if (volatileImage.validate(graphicsConfiguration) == 2) {
                    repaintManager.resetVolatileDoubleBuffer(graphicsConfiguration);
                    image = repaintManager.getVolatileOffscreenBuffer(component, n4, n5);
                    volatileImage = (VolatileImage)image;
                }
                this.paintWithOffscreenBuffer(jComponent, graphics, n2, n3, n4, n5, image);
                bl2 = !volatileImage.contentsLost();
            }
        }
        if (!bl2 && (image = repaintManager.getOffscreenBuffer(component, n4, n5)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            this.paintWithOffscreenBuffer(jComponent, graphics, n2, n3, n4, n5, image);
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintWithOffscreenBuffer(JComponent jComponent, Graphics graphics, int n2, int n3, int n4, int n5, Image image) {
        Graphics graphics2 = image.getGraphics();
        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2);
        graphics2.dispose();
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        if (n6 > n4) {
            n6 = n4;
        }
        if (n7 > n5) {
            n7 = n5;
        }
        try {
            jComponent.setFlag(1, true);
            jComponent.setFlag(2, true);
            int n8 = n2 + n4;
            for (int i2 = n2; i2 < n8; i2 += n6) {
                int n9 = n3 + n5;
                for (int i3 = n3; i3 < n9; i3 += n7) {
                    if (i3 + n7 >= n9 && i2 + n6 >= n8) {
                        jComponent.setFlag(2, false);
                    }
                    graphics3.translate(-i2, -i3);
                    graphics3.setClip(i2, i3, n6, n7);
                    if (jComponent.getFlag(13)) {
                        jComponent.paint(graphics3);
                    } else {
                        if (!jComponent.rectangleIsObscured(n2, n3, n6, n7)) {
                            jComponent.paintComponent(graphics3);
                            jComponent.paintBorder(graphics3);
                        }
                        jComponent.paintChildren(graphics3);
                    }
                    graphics.setClip(i2, i3, n6, n7);
                    graphics.drawImage(image, i2, i3, jComponent);
                    graphics3.translate(i2, i3);
                }
            }
            Object var17_16 = null;
            jComponent.setFlag(1, false);
            jComponent.setFlag(2, false);
            graphics3.dispose();
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            jComponent.setFlag(1, false);
            jComponent.setFlag(2, false);
            graphics3.dispose();
            throw throwable;
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n2) {
        InputMap inputMap = this.getInputMap(n2, true);
        if (inputMap != null) {
            ActionMap actionMap = this.getActionMap(true);
            ActionStandin actionStandin = new ActionStandin(this, actionListener, string);
            inputMap.put(keyStroke, actionStandin);
            if (actionMap != null) {
                actionMap.put(actionStandin, actionStandin);
            }
        }
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;
        private final JComponent this$0;

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler(this);
                this.this$0.addFocusListener(this.accessibleFocusHandler);
            }
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler(this);
                this.this$0.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler != null) {
                this.this$0.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public String getAccessibleDescription() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleDescription;
            if (string == null) {
                try {
                    string = this.getToolTipText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null && (object = this.this$0.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleDescription();
            }
            return string;
        }

        public String getAccessibleName() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleName;
            if (string == null) {
                string = this.getBorderTitle(this.this$0.getBorder());
            }
            if (string == null && (object = this.this$0.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public String getTitledBorderText() {
            Border border = this.this$0.getBorder();
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        public Accessible getAccessibleChild(int n2) {
            return super.getAccessibleChild(n2);
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }

        protected AccessibleJComponent(JComponent jComponent) {
            this.this$0 = jComponent;
            super(jComponent);
            this.accessibleContainerHandler = null;
            this.accessibleFocusHandler = null;
        }

        protected String getBorderTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                String string = this.getBorderTitle(((CompoundBorder)border).getInsideBorder());
                if (string == null) {
                    string = this.getBorderTitle(((CompoundBorder)border).getOutsideBorder());
                }
                return string;
            }
            return null;
        }

        static JComponent access$100(AccessibleJComponent accessibleJComponent) {
            return accessibleJComponent.this$0;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private final AccessibleJComponent this$1;

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    this.this$1.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    this.this$1.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }

            protected AccessibleContainerHandler(AccessibleJComponent accessibleJComponent) {
                this.this$1 = accessibleJComponent;
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            private final AccessibleJComponent this$1;

            public void focusGained(FocusEvent focusEvent) {
                if (AccessibleJComponent.access$100((AccessibleJComponent)this.this$1).accessibleContext != null) {
                    AccessibleJComponent.access$100((AccessibleJComponent)this.this$1).accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (AccessibleJComponent.access$100((AccessibleJComponent)this.this$1).accessibleContext != null) {
                    AccessibleJComponent.access$100((AccessibleJComponent)this.this$1).accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }

            protected AccessibleFocusHandler(AccessibleJComponent accessibleJComponent) {
                this.this$1 = accessibleJComponent;
            }
        }
    }

    final class ActionStandin
    implements Action {
        private final ActionListener actionListener;
        private final String command;
        private final Action action;
        private final JComponent this$0;

        public boolean isEnabled() {
            if (this.actionListener == null) {
                return false;
            }
            if (this.action == null) {
                return true;
            }
            return this.action.isEnabled();
        }

        public void setEnabled(boolean bl2) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        static ActionListener access$000(ActionStandin actionStandin) {
            return actionStandin.actionListener;
        }

        public Object getValue(String string) {
            if (string != null) {
                if (string.equals("ActionCommandKey")) {
                    return this.command;
                }
                if (this.action != null) {
                    return this.action.getValue(string);
                }
                if (string.equals("Name")) {
                    return "ActionStandin";
                }
            }
            return null;
        }

        public void putValue(String string, Object object) {
        }

        ActionStandin(JComponent jComponent, ActionListener actionListener, String string) {
            this.this$0 = jComponent;
            this.actionListener = actionListener;
            this.action = actionListener instanceof Action ? (Action)actionListener : null;
            this.command = string;
        }
    }

    private class EnableSerializationFocusListener
    implements FocusListener,
    Serializable {
        private final JComponent this$0;

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            this.this$0.compWriteObjectNotify();
        }

        private EnableSerializationFocusListener(JComponent jComponent) {
            this.this$0 = jComponent;
        }

        EnableSerializationFocusListener(JComponent jComponent, 1 var2_2) {
            this(jComponent);
        }
    }

    static final class IntVector {
        int[] array = null;
        int count = 0;
        int capacity = 0;

        int size() {
            return this.count;
        }

        IntVector() {
        }

        int elementAt(int n2) {
            return this.array[n2];
        }

        void addElement(int n2) {
            if (this.count == this.capacity) {
                this.capacity = (this.capacity + 2) * 2;
                int[] nArray = new int[this.capacity];
                if (this.count > 0) {
                    System.arraycopy(this.array, 0, nArray, 0, this.count);
                }
                this.array = nArray;
            }
            this.array[this.count++] = n2;
        }

        void setElementAt(int n2, int n3) {
            this.array[n3] = n2;
        }
    }

    static class KeyboardState
    implements Serializable {
        private static final Object keyCodesKey = class$javax$swing$JComponent$KeyboardState == null ? (class$javax$swing$JComponent$KeyboardState = JComponent.class$("javax.swing.JComponent$KeyboardState")) : class$javax$swing$JComponent$KeyboardState;

        KeyboardState() {
        }

        static void registerKeyPressed(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (intVector.elementAt(i2) != -1) continue;
                intVector.setElementAt(n2, i2);
                return;
            }
            intVector.addElement(n2);
        }

        static void registerKeyReleased(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (intVector.elementAt(i2) != n2) continue;
                intVector.setElementAt(-1, i2);
                return;
            }
        }

        static boolean keyIsPressed(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (intVector.elementAt(i2) != n2) continue;
                return true;
            }
            return false;
        }

        static boolean shouldProcess(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (!KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyPressed(keyEvent.getKeyCode());
                    }
                    return true;
                }
                case 402: {
                    if (KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyReleased(keyEvent.getKeyCode());
                        return true;
                    }
                    return false;
                }
                case 400: {
                    return true;
                }
            }
            return false;
        }

        static IntVector getKeyCodeArray() {
            IntVector intVector = (IntVector)SwingUtilities.appContextGet(keyCodesKey);
            if (intVector == null) {
                intVector = new IntVector();
                SwingUtilities.appContextPut(keyCodesKey, intVector);
            }
            return intVector;
        }
    }

    private class ReadObjectCallback
    implements ObjectInputValidation {
        private final Vector roots;
        private final ObjectInputStream inputStream;
        private final JComponent this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateObject() throws InvalidObjectException {
            try {
                for (int i2 = 0; i2 < this.roots.size(); ++i2) {
                    JComponent jComponent = (JComponent)this.roots.elementAt(i2);
                    SwingUtilities.updateComponentTreeUI(jComponent);
                }
            }
            finally {
                JComponent.access$300().remove(this.inputStream);
            }
        }

        private void registerComponent(JComponent jComponent) {
            Container container;
            JComponent jComponent2;
            int n2;
            for (n2 = 0; n2 < this.roots.size(); ++n2) {
                jComponent2 = (JComponent)this.roots.elementAt(n2);
                for (container = jComponent; container != null; container = container.getParent()) {
                    if (container != jComponent2) continue;
                    return;
                }
            }
            block2: for (n2 = 0; n2 < this.roots.size(); ++n2) {
                jComponent2 = (JComponent)this.roots.elementAt(n2);
                for (container = jComponent2.getParent(); container != null; container = container.getParent()) {
                    if (container != jComponent) continue;
                    this.roots.removeElementAt(n2--);
                    continue block2;
                }
            }
            this.roots.addElement(jComponent);
        }

        ReadObjectCallback(JComponent jComponent, ObjectInputStream objectInputStream) throws Exception {
            this.this$0 = jComponent;
            this.roots = new Vector(1);
            this.inputStream = objectInputStream;
            objectInputStream.registerValidation(this, 0);
        }

        static void access$400(ReadObjectCallback readObjectCallback, JComponent jComponent) {
            readObjectCallback.registerComponent(jComponent);
        }
    }
}

