/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.io.ByteToCharCp1251;
import sun.io.CharToByteCp1251;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByteDecoder;
import sun.nio.cs.SingleByteEncoder;
import sun.nio.cs.StandardCharsets;

public class MS1251
extends Charset
implements HistoricallyNamedCharset {
    public MS1251() {
        super("windows-1251", StandardCharsets.aliasesFor("windows-1251"));
    }

    public String historicalName() {
        return "Cp1251";
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS1251;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends SingleByteDecoder {
        private static ByteToCharCp1251 b2c = new ByteToCharCp1251();

        public Decoder(Charset charset) {
            super(charset, b2c.getByteToCharTable());
        }
    }

    private static class Encoder
    extends SingleByteEncoder {
        private static CharToByteCp1251 c2b = new CharToByteCp1251();

        public Encoder(Charset charset) {
            super(charset, c2b.getIndex1(), c2b.getIndex2(), 65280, 255, 8);
        }
    }
}

